#ifndef __CDelayPanel__
#define __CDelayPanel__

#include <EGUI.h>
#include <EMusic.h>

namespace Exponent
{
	namespace SCal
	{
		/**
		 * @class CDelayPanel CDelayPanel.hpp
		 * @brief Control to represent the delay calculator
		 *
		 * @date 17/12/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 * 
		 * $Id: CDelayPanel.hpp,v 1.4 2007/02/11 02:20:27 paul Exp $
		 */
		class CDelayPanel : public CControlPanel, public IActionListener
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param root The root control that this control is being added to
			 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
			 * @param area The area of this control relative to the root controls top left
			 * @param divisionMenu The divisions menu for the delay division
			 */
			CDelayPanel(IControlRoot *root, const long uniqueId, const CRect &area, CMenu *divisionMenu);

			/**
			 * Destruction
			 */
			virtual ~CDelayPanel();

//	===========================================================================

			/**
			 * Handle the action event
			 */
			virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

		protected:

//	===========================================================================

			/**
			 * Compute the delay time
			 */
			void computeDelayTime();

//	===========================================================================
			
			/**
			 * @enum EControlIds
			 * @brief Enumeration of control identifiers
			 */
			enum EControlIds
			{
				e_delayBpmEditBox = 0,							/**< Edit box for delay bpm */
				e_delayDivisionComboBox,						/**< Combo box for division in delay */
			};

//	===========================================================================

			CTextEdit *m_delayBpmEditBox;						/**< Edit box for delay convertor bpm */
			CComboBox *m_delayDivisionComboBox;					/**< Division combo box */
			CTextLabel *m_delayOutputValueLabel;				/**< Delay output label */
			CMusicMath::ETempoDivision m_delayDivision;			/**< division of the delay */

		};
	}
}
#endif	// End of CDelayPanel.hpp